package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * List accounts request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ListAccountsRequestDto {

    private final long limit;
    private final String pageToken;
    private final boolean withProvisions;
    private final Boolean includeDeleted;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;

    @JsonCreator
    public ListAccountsRequestDto(@JsonProperty("limit") long limit,
                                  @JsonProperty("pageToken") String pageToken,
                                  @JsonProperty("withProvisions") boolean withProvisions,
                                  @JsonProperty("includeDeleted") Boolean includeDeleted,
                                  @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey) {
        this.limit = limit;
        this.pageToken = pageToken;
        this.withProvisions = withProvisions;
        this.includeDeleted = includeDeleted;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public long getLimit() {
        return limit;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getPageToken() {
        return Optional.ofNullable(pageToken);
    }

    public boolean isWithProvisions() {
        return withProvisions;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<Boolean> getIncludeDeleted() {
        return Optional.ofNullable(includeDeleted);
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListAccountsRequestDto that = (ListAccountsRequestDto) o;
        return limit == that.limit &&
                withProvisions == that.withProvisions &&
                Objects.equals(pageToken, that.pageToken) &&
                Objects.equals(includeDeleted, that.includeDeleted) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(limit, pageToken, withProvisions, includeDeleted, accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "ListAccountsRequestDto{" +
                "limit=" + limit +
                ", pageToken='" + pageToken + '\'' +
                ", withProvisions=" + withProvisions +
                ", includeDeleted=" + includeDeleted +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

}
