package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * List accounts response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class ListAccountsResponseDto {

    private final List<AccountDto> accounts;
    private final String nextPageToken;

    @JsonCreator
    public ListAccountsResponseDto(@JsonProperty("accounts") List<AccountDto> accounts,
                                   @JsonProperty("nextPageToken") String nextPageToken) {
        this.accounts = accounts;
        this.nextPageToken = nextPageToken;
    }

    public Optional<List<AccountDto>> getAccounts() {
        return Optional.ofNullable(accounts);
    }

    public Optional<String> getNextPageToken() {
        return Optional.ofNullable(nextPageToken);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListAccountsResponseDto that = (ListAccountsResponseDto) o;
        return Objects.equals(accounts, that.accounts) &&
                Objects.equals(nextPageToken, that.nextPageToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accounts, nextPageToken);
    }

    @Override
    public String toString() {
        return "ListAccountsResponse{" +
                "accounts=" + accounts +
                ", nextPageToken='" + nextPageToken + '\'' +
                '}';
    }

}
