package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Move account request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class MoveAccountRequestDto {

    private final String sourceFolderId;
    private final String destinationFolderId;
    private final long sourceAbcServiceId;
    private final long destinationAbcServiceId;
    private final List<KnownAccountProvisionsDto> knownSourceProvisions;
    private final List<KnownAccountProvisionsDto> knownDestinationProvisions;
    private final UserIdDto author;
    private final String operationId;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public MoveAccountRequestDto(
            @JsonProperty("sourceFolderId") String sourceFolderId,
            @JsonProperty("destinationFolderId") String destinationFolderId,
            @JsonProperty("sourceAbcServiceId") long sourceAbcServiceId,
            @JsonProperty("destinationAbcServiceId") long destinationAbcServiceId,
            @JsonProperty("knownSourceProvisions") List<KnownAccountProvisionsDto> knownSourceProvisions,
            @JsonProperty("knownDestinationProvisions") List<KnownAccountProvisionsDto> knownDestinationProvisions,
            @JsonProperty("author") UserIdDto author,
            @JsonProperty("operationId") String operationId,
            @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey) {
        this.sourceFolderId = sourceFolderId;
        this.destinationFolderId = destinationFolderId;
        this.sourceAbcServiceId = sourceAbcServiceId;
        this.destinationAbcServiceId = destinationAbcServiceId;
        this.knownSourceProvisions = knownSourceProvisions;
        this.knownDestinationProvisions = knownDestinationProvisions;
        this.author = author;
        this.operationId = operationId;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public String getSourceFolderId() {
        return sourceFolderId;
    }

    public String getDestinationFolderId() {
        return destinationFolderId;
    }

    public long getSourceAbcServiceId() {
        return sourceAbcServiceId;
    }

    public long getDestinationAbcServiceId() {
        return destinationAbcServiceId;
    }

    public List<KnownAccountProvisionsDto> getKnownSourceProvisions() {
        return knownSourceProvisions;
    }

    public List<KnownAccountProvisionsDto> getKnownDestinationProvisions() {
        return knownDestinationProvisions;
    }

    public UserIdDto getAuthor() {
        return author;
    }

    public String getOperationId() {
        return operationId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MoveAccountRequestDto that = (MoveAccountRequestDto) o;
        return sourceAbcServiceId == that.sourceAbcServiceId &&
                destinationAbcServiceId == that.destinationAbcServiceId &&
                Objects.equals(sourceFolderId, that.sourceFolderId) &&
                Objects.equals(destinationFolderId, that.destinationFolderId) &&
                Objects.equals(knownSourceProvisions, that.knownSourceProvisions) &&
                Objects.equals(knownDestinationProvisions, that.knownDestinationProvisions) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sourceFolderId, destinationFolderId, sourceAbcServiceId, destinationAbcServiceId,
                knownSourceProvisions, knownDestinationProvisions, author, operationId, accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "MoveAccountRequestDto{" +
                "sourceFolderId='" + sourceFolderId + '\'' +
                ", destinationFolderId='" + destinationFolderId + '\'' +
                ", sourceAbcServiceId=" + sourceAbcServiceId +
                ", destinationAbcServiceId=" + destinationAbcServiceId +
                ", knownSourceProvisions=" + knownSourceProvisions +
                ", knownDestinationProvisions=" + knownDestinationProvisions +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

}
