package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Move provision response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class MoveProvisionResponseDto {

    private final List<ProvisionDto> sourceProvisions;
    private final List<ProvisionDto> destinationProvisions;
    private final AccountsSpaceKeyResponseDto accountsSpaceKey;
    private final Long sourceAccountVersion;
    private final Long destinationAccountVersion;

    @JsonCreator
    public MoveProvisionResponseDto(@JsonProperty("sourceProvisions") List<ProvisionDto> sourceProvisions,
                                    @JsonProperty("destinationProvisions") List<ProvisionDto> destinationProvisions,
                                    @JsonProperty("accountsSpaceKey") AccountsSpaceKeyResponseDto accountsSpaceKey,
                                    @JsonProperty("sourceAccountVersion") Long sourceAccountVersion,
                                    @JsonProperty("destinationAccountVersion") Long destinationAccountVersion) {
        this.sourceProvisions = sourceProvisions;
        this.destinationProvisions = destinationProvisions;
        this.accountsSpaceKey = accountsSpaceKey;
        this.sourceAccountVersion = sourceAccountVersion;
        this.destinationAccountVersion = destinationAccountVersion;
    }

    public Optional<List<ProvisionDto>> getSourceProvisions() {
        return Optional.ofNullable(sourceProvisions);
    }

    public Optional<List<ProvisionDto>> getDestinationProvisions() {
        return Optional.ofNullable(destinationProvisions);
    }

    public Optional<AccountsSpaceKeyResponseDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    public Optional<Long> getSourceAccountVersion() {
        return Optional.ofNullable(sourceAccountVersion);
    }

    public Optional<Long> getDestinationAccountVersion() {
        return Optional.ofNullable(destinationAccountVersion);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MoveProvisionResponseDto that = (MoveProvisionResponseDto) o;
        return Objects.equals(sourceProvisions, that.sourceProvisions) &&
                Objects.equals(destinationProvisions, that.destinationProvisions) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey) &&
                Objects.equals(sourceAccountVersion, that.sourceAccountVersion) &&
                Objects.equals(destinationAccountVersion, that.destinationAccountVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sourceProvisions, destinationProvisions, accountsSpaceKey, sourceAccountVersion,
                destinationAccountVersion);
    }

    @Override
    public String toString() {
        return "MoveProvisionResponseDto{" +
                "sourceProvisions=" + sourceProvisions +
                ", destinationProvisions=" + destinationProvisions +
                ", accountsSpaceKey=" + accountsSpaceKey +
                ", sourceAccountVersion=" + sourceAccountVersion +
                ", destinationAccountVersion=" + destinationAccountVersion +
                '}';
    }

}
