package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Provision.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class ProvisionDto {

    private final ResourceKeyResponseDto resourceKey;
    private final Long providedAmount;
    private final String providedAmountUnitKey;
    private final Long allocatedAmount;
    private final String allocatedAmountUnitKey;
    private final LastUpdateDto lastUpdate;
    private final Long quotaVersion;

    @JsonCreator
    public ProvisionDto(@JsonProperty("resourceKey") ResourceKeyResponseDto resourceKey,
                        @JsonProperty("providedAmount") Long providedAmount,
                        @JsonProperty("providedAmountUnitKey") String providedAmountUnitKey,
                        @JsonProperty("allocatedAmount") Long allocatedAmount,
                        @JsonProperty("allocatedAmountUnitKey") String allocatedAmountUnitKey,
                        @JsonProperty("lastUpdate") LastUpdateDto lastUpdate,
                        @JsonProperty("quotaVersion") Long quotaVersion) {
        this.resourceKey = resourceKey;
        this.providedAmount = providedAmount;
        this.providedAmountUnitKey = providedAmountUnitKey;
        this.allocatedAmount = allocatedAmount;
        this.allocatedAmountUnitKey = allocatedAmountUnitKey;
        this.lastUpdate = lastUpdate;
        this.quotaVersion = quotaVersion;
    }

    public Optional<ResourceKeyResponseDto> getResourceKey() {
        return Optional.ofNullable(resourceKey);
    }

    public Optional<Long> getProvidedAmount() {
        return Optional.ofNullable(providedAmount);
    }

    public Optional<String> getProvidedAmountUnitKey() {
        return Optional.ofNullable(providedAmountUnitKey);
    }

    public Optional<Long> getAllocatedAmount() {
        return Optional.ofNullable(allocatedAmount);
    }

    public Optional<String> getAllocatedAmountUnitKey() {
        return Optional.ofNullable(allocatedAmountUnitKey);
    }

    public Optional<LastUpdateDto> getLastUpdate() {
        return Optional.ofNullable(lastUpdate);
    }

    public Optional<Long> getQuotaVersion() {
        return Optional.ofNullable(quotaVersion);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionDto that = (ProvisionDto) o;
        return Objects.equals(resourceKey, that.resourceKey) &&
                Objects.equals(providedAmount, that.providedAmount) &&
                Objects.equals(providedAmountUnitKey, that.providedAmountUnitKey) &&
                Objects.equals(allocatedAmount, that.allocatedAmount) &&
                Objects.equals(allocatedAmountUnitKey, that.allocatedAmountUnitKey) &&
                Objects.equals(lastUpdate, that.lastUpdate) &&
                Objects.equals(quotaVersion, that.quotaVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceKey, providedAmount, providedAmountUnitKey, allocatedAmount,
                allocatedAmountUnitKey, lastUpdate, quotaVersion);
    }

    @Override
    public String toString() {
        return "ProvisionDto{" +
                "resourceKey=" + resourceKey +
                ", providedAmount=" + providedAmount +
                ", providedAmountUnitKey='" + providedAmountUnitKey + '\'' +
                ", allocatedAmount=" + allocatedAmount +
                ", allocatedAmountUnitKey='" + allocatedAmountUnitKey + '\'' +
                ", lastUpdate=" + lastUpdate +
                ", quotaVersion=" + quotaVersion +
                '}';
    }

}
