package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Rename account request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class RenameAccountRequestDto {

    private final String folderId;
    private final long abcServiceId;
    private final String displayName;
    private final UserIdDto author;
    private final String operationId;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;

    @JsonCreator
    public RenameAccountRequestDto(@JsonProperty("folderId") String folderId,
                                   @JsonProperty("abcServiceId") long abcServiceId,
                                   @JsonProperty("displayName") String displayName,
                                   @JsonProperty("author") UserIdDto author,
                                   @JsonProperty("operationId") String operationId,
                                   @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey) {
        this.folderId = folderId;
        this.abcServiceId = abcServiceId;
        this.displayName = displayName;
        this.author = author;
        this.operationId = operationId;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public String getFolderId() {
        return folderId;
    }

    public long getAbcServiceId() {
        return abcServiceId;
    }

    public String getDisplayName() {
        return displayName;
    }

    public UserIdDto getAuthor() {
        return author;
    }

    public String getOperationId() {
        return operationId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RenameAccountRequestDto that = (RenameAccountRequestDto) o;
        return abcServiceId == that.abcServiceId &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, abcServiceId, displayName, author, operationId, accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "RenameAccountRequestDto{" +
                "folderId='" + folderId + '\'' +
                ", abcServiceId=" + abcServiceId +
                ", displayName='" + displayName + '\'' +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

}
