package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import ru.yandex.intranet.d.backend.service.provider_proto.ResourceKey;
import ru.yandex.intranet.d.backend.service.provider_proto.ResourceSegmentKey;
import ru.yandex.intranet.d.web.model.imports.ResourceIdentityDto;
import ru.yandex.intranet.d.web.model.imports.SegmentKey;

/**
 * Resource complex key for using as map key.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 13-07-2021
 */
public final class ResourceComplexKey {
    private final String resourceTypeKey;
    private final Map<String, String> segmentKeyBySegmentationKey;

    public ResourceComplexKey(String resourceTypeKey, Map<String, String> segmentKeyBySegmentationKey) {
        this.resourceTypeKey = resourceTypeKey;
        this.segmentKeyBySegmentationKey = segmentKeyBySegmentationKey;
    }

    public ResourceComplexKey(ResourceKeyResponseDto resource) {
        this.resourceTypeKey = resource.getResourceTypeKey().orElse(null);
        this.segmentKeyBySegmentationKey = resource.getSegmentation().map(segments -> segments.stream()
                .collect(Collectors.toMap(
                        responseDto -> responseDto.getSegmentationKey().get(),
                        responseDto -> responseDto.getSegmentKey().get())
                ))
                .orElse(Map.of());
    }

    public ResourceComplexKey(ResourceIdentityDto resource) {
        this.resourceTypeKey = resource.getResourceTypeKey().orElse(null);
        this.segmentKeyBySegmentationKey = resource.getSegments().map(segments -> segments.stream()
                .collect(Collectors.toMap(
                        SegmentKey::getSegmentationKey,
                        SegmentKey::getSegmentKey
                )))
                .orElse(Map.of());
    }

    public ResourceComplexKey(ResourceKey resource) {
        this.resourceTypeKey = resource.getCompoundKey().getResourceTypeKey();
        this.segmentKeyBySegmentationKey = resource.getCompoundKey().getResourceSegmentKeysList().stream()
                .collect(Collectors.toMap(
                        ResourceSegmentKey::getResourceSegmentationKey,
                        ResourceSegmentKey::getResourceSegmentKey
                ));
    }

    public String getResourceTypeKey() {
        return resourceTypeKey;
    }

    public Map<String, String> getSegmentKeyBySegmentationKey() {
        return segmentKeyBySegmentationKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceComplexKey that = (ResourceComplexKey) o;
        return Objects.equals(resourceTypeKey, that.resourceTypeKey) && Objects.equals(segmentKeyBySegmentationKey,
                that.segmentKeyBySegmentationKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeKey, segmentKeyBySegmentationKey);
    }

    @Override
    public String toString() {
        return "ResourceComplexKey{" +
                "resourceTypeKey='" + resourceTypeKey + '\'' +
                ", segmentKeyBySegmentationKey=" + segmentKeyBySegmentationKey +
                '}';
    }
}
