package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Resource key request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceKeyRequestDto {

    private final String resourceTypeKey;
    private final List<SegmentKeyRequestDto> segmentation;

    @JsonCreator
    public ResourceKeyRequestDto(@JsonProperty("resourceTypeKey") String resourceTypeKey,
                                 @JsonProperty("segmentation") List<SegmentKeyRequestDto> segmentation) {
        this.resourceTypeKey = resourceTypeKey;
        this.segmentation = segmentation;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getResourceTypeKey() {
        return Optional.ofNullable(resourceTypeKey);
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<List<SegmentKeyRequestDto>> getSegmentation() {
        return Optional.ofNullable(segmentation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceKeyRequestDto that = (ResourceKeyRequestDto) o;
        return Objects.equals(resourceTypeKey, that.resourceTypeKey) &&
                Objects.equals(segmentation, that.segmentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeKey, segmentation);
    }

    @Override
    public String toString() {
        return "ResourceKeyRequestDto{" +
                "resourceTypeKey='" + resourceTypeKey + '\'' +
                ", segmentation=" + segmentation +
                '}';
    }

}
