package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Resource key response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ResourceKeyResponseDto {

    private final String resourceTypeKey;
    private final List<SegmentKeyResponseDto> segmentation;

    @JsonCreator
    public ResourceKeyResponseDto(@JsonProperty("resourceTypeKey") String resourceTypeKey,
                                  @JsonProperty("segmentation") List<SegmentKeyResponseDto> segmentation) {
        this.resourceTypeKey = resourceTypeKey;
        this.segmentation = segmentation;
    }

    public Optional<String> getResourceTypeKey() {
        return Optional.ofNullable(resourceTypeKey);
    }

    public Optional<List<SegmentKeyResponseDto>> getSegmentation() {
        return Optional.ofNullable(segmentation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceKeyResponseDto that = (ResourceKeyResponseDto) o;
        return Objects.equals(resourceTypeKey, that.resourceTypeKey) &&
                Objects.equals(segmentation, that.segmentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeKey, segmentation);
    }

    @Override
    public String toString() {
        return "ResourceKeyResponseDto{" +
                "resourceTypeKey='" + resourceTypeKey + '\'' +
                ", segmentation=" + segmentation +
                '}';
    }

}
