package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Segment key request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class SegmentKeyRequestDto {

    private final String segmentationKey;
    private final String segmentKey;

    @JsonCreator
    public SegmentKeyRequestDto(@JsonProperty("segmentationKey") String segmentationKey,
                                @JsonProperty("segmentKey") String segmentKey) {
        this.segmentationKey = segmentationKey;
        this.segmentKey = segmentKey;
    }

    public String getSegmentationKey() {
        return segmentationKey;
    }

    public String getSegmentKey() {
        return segmentKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentKeyRequestDto that = (SegmentKeyRequestDto) o;
        return Objects.equals(segmentationKey, that.segmentationKey) && Objects.equals(segmentKey, that.segmentKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationKey, segmentKey);
    }

    @Override
    public String toString() {
        return "SegmentKeyRequestDto{" +
                "segmentationKey='" + segmentationKey + '\'' +
                ", segmentKey='" + segmentKey + '\'' +
                '}';
    }

}
