package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Segment key response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class SegmentKeyResponseDto {

    private final String segmentationKey;
    private final String segmentKey;

    @JsonCreator
    public SegmentKeyResponseDto(@JsonProperty("segmentationKey") String segmentationKey,
                                 @JsonProperty("segmentKey") String segmentKey) {
        this.segmentationKey = segmentationKey;
        this.segmentKey = segmentKey;
    }

    public Optional<String> getSegmentationKey() {
        return Optional.ofNullable(segmentationKey);
    }

    public Optional<String> getSegmentKey() {
        return Optional.ofNullable(segmentKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentKeyResponseDto that = (SegmentKeyResponseDto) o;
        return Objects.equals(segmentationKey, that.segmentationKey) && Objects.equals(segmentKey, that.segmentKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationKey, segmentKey);
    }

    @Override
    public String toString() {
        return "SegmentKeyResponseDto{" +
                "segmentationKey='" + segmentationKey + '\'' +
                ", segmentKey='" + segmentKey + '\'' +
                '}';
    }

}
