package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Update provision request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UpdateProvisionRequestDto {

    private final String folderId;
    private final long abcServiceId;
    private final List<ProvisionRequestDto> updatedProvisions;
    private final List<KnownAccountProvisionsDto> knownProvisions;
    private final UserIdDto author;
    private final String operationId;
    private final AccountsSpaceKeyRequestDto accountsSpaceKey;

    @JsonCreator
    public UpdateProvisionRequestDto(@JsonProperty("folderId") String folderId,
                                     @JsonProperty("abcServiceId") long abcServiceId,
                                     @JsonProperty("updatedProvisions") List<ProvisionRequestDto> updatedProvisions,
                                     @JsonProperty("knownProvisions") List<KnownAccountProvisionsDto> knownProvisions,
                                     @JsonProperty("author") UserIdDto author,
                                     @JsonProperty("operationId") String operationId,
                                     @JsonProperty("accountsSpaceKey") AccountsSpaceKeyRequestDto accountsSpaceKey) {
        this.folderId = folderId;
        this.abcServiceId = abcServiceId;
        this.updatedProvisions = updatedProvisions;
        this.knownProvisions = knownProvisions;
        this.author = author;
        this.operationId = operationId;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public String getFolderId() {
        return folderId;
    }

    public long getAbcServiceId() {
        return abcServiceId;
    }

    public List<ProvisionRequestDto> getUpdatedProvisions() {
        return updatedProvisions;
    }

    public List<KnownAccountProvisionsDto> getKnownProvisions() {
        return knownProvisions;
    }

    public UserIdDto getAuthor() {
        return author;
    }

    public String getOperationId() {
        return operationId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<AccountsSpaceKeyRequestDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionRequestDto that = (UpdateProvisionRequestDto) o;
        return abcServiceId == that.abcServiceId &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(updatedProvisions, that.updatedProvisions) &&
                Objects.equals(knownProvisions, that.knownProvisions) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, abcServiceId, updatedProvisions, knownProvisions, author, operationId,
                accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "UpdateProvisionRequestDto{" +
                "folderId='" + folderId + '\'' +
                ", abcServiceId=" + abcServiceId +
                ", updatedProvisions=" + updatedProvisions +
                ", knownProvisions=" + knownProvisions +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

}
