package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Update provision response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class UpdateProvisionResponseDto {

    private final List<ProvisionDto> provisions;
    private final Long accountVersion;
    private final AccountsSpaceKeyResponseDto accountsSpaceKey;

    @JsonCreator
    public UpdateProvisionResponseDto(@JsonProperty("provisions") List<ProvisionDto> provisions,
                                      @JsonProperty("accountVersion") Long accountVersion,
                                      @JsonProperty("accountsSpaceKey") AccountsSpaceKeyResponseDto accountsSpaceKey) {
        this.provisions = provisions;
        this.accountVersion = accountVersion;
        this.accountsSpaceKey = accountsSpaceKey;
    }

    public Optional<List<ProvisionDto>> getProvisions() {
        return Optional.ofNullable(provisions);
    }

    public Optional<Long> getAccountVersion() {
        return Optional.ofNullable(accountVersion);
    }

    public Optional<AccountsSpaceKeyResponseDto> getAccountsSpaceKey() {
        return Optional.ofNullable(accountsSpaceKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionResponseDto that = (UpdateProvisionResponseDto) o;
        return Objects.equals(provisions, that.provisions) &&
                Objects.equals(accountVersion, that.accountVersion) &&
                Objects.equals(accountsSpaceKey, that.accountsSpaceKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provisions, accountVersion, accountsSpaceKey);
    }

    @Override
    public String toString() {
        return "UpdateProvisionResponseDto{" +
                "provisions=" + provisions +
                ", accountVersion=" + accountVersion +
                ", accountsSpaceKey=" + accountsSpaceKey +
                '}';
    }

}
