package ru.yandex.intranet.d.services.integration.providers.rest.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * User id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class UserIdDto {

    private final String passportUid;
    private final String staffLogin;

    @JsonCreator
    public UserIdDto(@JsonProperty("passportUid") String passportUid,
                     @JsonProperty("staffLogin") String staffLogin) {
        this.passportUid = passportUid;
        this.staffLogin = staffLogin;
    }

    public Optional<String> getPassportUid() {
        return Optional.ofNullable(passportUid);
    }

    public Optional<String> getStaffLogin() {
        return Optional.ofNullable(staffLogin);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserIdDto userId = (UserIdDto) o;
        return Objects.equals(passportUid, userId.passportUid) &&
                Objects.equals(staffLogin, userId.staffLogin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(passportUid, staffLogin);
    }

    @Override
    public String toString() {
        return "UserId{" +
                "passportUid='" + passportUid + '\'' +
                ", staffLogin='" + staffLogin + '\'' +
                '}';
    }

}
