package ru.yandex.intranet.d.services.integration.providers.security;

import io.grpc.CallCredentials;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.services.integration.providers.grpc.TvmCallCredentials;

/**
 * Provider API authentication supplier implementation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile({"dev", "testing", "production", "load-testing", "local"})
public class GrpcCallCredentialsSupplierImpl implements GrpcCallCredentialsSupplier {

    @Override
    public CallCredentials getCredentials(String tvmTicket) {
        return new TvmCallCredentials(tvmTicket);
    }

}
