package ru.yandex.intranet.d.services.integration.solomon

import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component
import ru.yandex.monitoring.api.v3.ReadMetricsDataRequest
import ru.yandex.monitoring.api.v3.ReadMetricsDataResponse
import ru.yandex.monitoring.api.v3.ReadMetricsDataResponse.TimeseriesVector
import ru.yandex.monitoring.api.v3.Timeseries
import java.util.concurrent.ConcurrentHashMap

/**
 * Solomon client stub.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile("local", "load-testing", "test-recipe", "integration-tests")
class SolomonClientStub: SolomonClient {

    private val stubData: MutableMap<String, Timeseries> = ConcurrentHashMap()

    override suspend fun readData(request: ReadMetricsDataRequest): SolomonResponse<ReadMetricsDataResponse> {
        val matchingData = stubData.filterKeys { request.query.contains(it) }
        val response = ReadMetricsDataResponse.newBuilder()
            .setTimeseriesVector(TimeseriesVector.newBuilder()
                .addAllValues(matchingData.values)
                .build())
            .build()
        return SolomonResponse.success(response, null, null)
    }

    fun setStubData(data: Map<String, Timeseries>) {
        stubData.clear()
        stubData.putAll(data)
    }

}
