package ru.yandex.intranet.d.services.integration.solomon

import io.grpc.Status

sealed interface SolomonResponse<T> {
    data class Success<U>(val value: U, val outgoingRequestId: String?, val incomingRequestId: String?): SolomonResponse<U>
    data class Failure<U>(val error: Throwable, val outgoingRequestId: String?): SolomonResponse<U>
    data class Error<U>(val statusCode: Status.Code, val description: String?, val badRequestDetails: Map<String, String>?,
                        val outgoingRequestId: String?, val incomingRequestId: String?): SolomonResponse<U>
    companion object {
        @JvmStatic
        fun <U> success(value: U, outgoingRequestId: String?, incomingRequestId: String?): SolomonResponse<U>
            = Success(value, outgoingRequestId, incomingRequestId)
        @JvmStatic
        fun <U> failure(error: Throwable, outgoingRequestId: String?): SolomonResponse<U>
            = Failure(error, outgoingRequestId)
        @JvmStatic
        fun <U> error(statusCode: Status.Code, description: String?, badRequestDetails: Map<String, String>?,
                  outgoingRequestId: String?, incomingRequestId: String?): SolomonResponse<U>
            = Error(statusCode, description, badRequestDetails, outgoingRequestId, incomingRequestId)
    }
}
