package ru.yandex.intranet.d.services.integration.yt

import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.asFlow
import ru.yandex.inside.yt.kosher.cypress.YPath
import java.util.concurrent.atomic.AtomicReference

/**
 * YT reader stub.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
class YtReaderStub: YtReader {
    private val rows: AtomicReference<List<*>> = AtomicReference(listOf<Any>())

    override suspend fun <T> readTable(path: YPath, clazz: Class<T>): Flow<T> {
        return (rows.get() as List<T>).asFlow()
    }

    override suspend fun checkClusterLiveness() {
    }

    override suspend fun checkNodeExists(node: YPath): Boolean {
        return true
    }

    fun setRows(newRows: List<*>) {
        rows.set(newRows)
    }

}
