package ru.yandex.intranet.d.services.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.LoanHistoryId
import java.time.Instant

@Schema(description = "Loans history page token.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class LoansHistoryPageToken @JsonCreator constructor(
    val eventTimestamp: Instant?,
    val historyId: LoanHistoryId?
)
