package ru.yandex.intranet.d.services.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.LoanId
import ru.yandex.intranet.d.model.loans.LoanStatus
import java.time.Instant

@Schema(description = "Pending loans page token.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class LoansPageToken @JsonCreator constructor(
    val status: LoanStatus?,
    val dueAt: Instant?,
    val loanId: LoanId?
)
