package ru.yandex.intranet.d.services.local;

import java.security.Principal;
import java.util.Locale;

import org.springframework.context.annotation.Profile;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
@Profile({"local", "integration-tests", "test-recipe"})
public class LocalServiceMock implements LocalService {
    private static final ResponseEntity<String> OK = ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).body("OK");

    @Override
    public Mono<ResponseEntity<String>> getLiveness() {
        return Mono.just(OK);
    }

    @Override
    public Mono<ResponseEntity<String>> getReadiness(boolean errorIs5xx) {
        return Mono.just(OK);
    }

    @Override
    public Mono<ResponseEntity<String>> getSchedulerStatus() {
        return Mono.just(OK);
    }

    @Override
    public Mono<ResponseEntity<?>> getAdminReadiness(Principal principal, Locale locale) {
        return Mono.just(OK);
    }
}
