package ru.yandex.intranet.d.services.notifications;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

/**
 * Notification mail sender service stub.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
@Profile({"local", "load-testing", "integration-tests", "test-recipe"})
public class NotificationMailSenderStub implements NotificationMailSender {

    private static final Logger LOG = LoggerFactory.getLogger(NotificationMailSenderStub.class);

    private final AtomicLong counter = new AtomicLong(0L);
    private final List<MailNotification> mail = new ArrayList<>();

    @Override
    public void sendBackground(MailNotification notification) {
        counter.incrementAndGet();
        mail.add(notification);
        LOG.info("Notification mail: {}", notification);
    }

    public long getCounter() {
        return counter.get();
    }

    public List<MailNotification> getMail() {
        return mail;
    }
}
