package ru.yandex.intranet.d.services.notifications;

import java.util.Objects;
import java.util.Set;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

/**
 * Notification mail exceptions configuration.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@ConstructorBinding
@ConfigurationProperties(prefix = "notifications.mail.exceptions")
public final class NotificationsMailExceptionsProperties {

    private final Set<String> doNotDisturb;

    public NotificationsMailExceptionsProperties(Set<String> doNotDisturb) {
        this.doNotDisturb = doNotDisturb;
    }

    public Set<String> getDoNotDisturb() {
        return doNotDisturb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NotificationsMailExceptionsProperties that = (NotificationsMailExceptionsProperties) o;
        return Objects.equals(doNotDisturb, that.doNotDisturb);
    }

    @Override
    public int hashCode() {
        return Objects.hash(doNotDisturb);
    }

    @Override
    public String toString() {
        return "NotificationsMailExceptionsProperties{" +
                "doNotDisturb=" + doNotDisturb +
                '}';
    }

}
