package ru.yandex.intranet.d.services.operations;

import java.time.Instant;
import java.util.Locale;
import java.util.Optional;

import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.datasource.model.YdbTxSession;
import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel;
import ru.yandex.intranet.d.services.operations.model.OperationCommonContext;
import ru.yandex.intranet.d.services.operations.model.OperationPostRefreshContext;
import ru.yandex.intranet.d.services.operations.model.OperationPreRefreshContext;
import ru.yandex.intranet.d.services.operations.model.OperationRefreshContext;
import ru.yandex.intranet.d.services.operations.model.OperationRetryContext;
import ru.yandex.intranet.d.services.operations.model.RetryableOperation;
import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Base operation retry service interface.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public interface BaseOperationRetryService {

    Mono<? extends Optional<? extends OperationPreRefreshContext>> preRefreshOperation(
            YdbTxSession session,
            RetryableOperation operation,
            OperationCommonContext context,
            Instant now,
            Locale locale);

    Mono<? extends Optional<? extends OperationRefreshContext>> refreshOperation(
            RetryableOperation operation,
            OperationPreRefreshContext context,
            Instant now,
            Locale locale);

    Mono<? extends Optional<? extends OperationPostRefreshContext>> postRefreshOperation(
            YdbTxSession session,
            RetryableOperation operation,
            OperationRefreshContext context,
            Instant now,
            Locale locale);

    Mono<? extends Optional<? extends OperationRetryContext>> retryOperation(
            RetryableOperation operation,
            OperationPostRefreshContext context,
            Instant now,
            Locale locale);

    Mono<Void> postRetryOperation(
            YdbTxSession session,
            RetryableOperation operation,
            OperationRetryContext retryContext,
            Instant now,
            Locale locale);

    Mono<Void> abortOperation(YdbTxSession session,
                              AccountsQuotasOperationsModel operation,
                              String comment,
                              Instant now,
                              YaUserDetails currentUser,
                              Locale locale);

}
