package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.folders.FolderModel;

/**
 * Create account application context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateAccountApplicationContext {

    private final FolderModel folder;
    private final AccountModel targetAccountByInternalId;
    private final AccountModel targetAccountByExternalId;

    public CreateAccountApplicationContext(FolderModel folder, AccountModel targetAccountByInternalId,
                                           AccountModel targetAccountByExternalId) {
        this.folder = folder;
        this.targetAccountByInternalId = targetAccountByInternalId;
        this.targetAccountByExternalId = targetAccountByExternalId;
    }

    public FolderModel getFolder() {
        return folder;
    }

    public Optional<AccountModel> getTargetAccountByInternalId() {
        return Optional.ofNullable(targetAccountByInternalId);
    }

    public Optional<AccountModel> getTargetAccountByExternalId() {
        return Optional.ofNullable(targetAccountByExternalId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountApplicationContext that = (CreateAccountApplicationContext) o;
        return Objects.equals(folder, that.folder) &&
                Objects.equals(targetAccountByInternalId, that.targetAccountByInternalId) &&
                Objects.equals(targetAccountByExternalId, that.targetAccountByExternalId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folder, targetAccountByInternalId, targetAccountByExternalId);
    }

    @Override
    public String toString() {
        return "CreateAccountApplicationContext{" +
                "folder=" + folder +
                ", targetAccountByInternalId=" + targetAccountByInternalId +
                ", targetAccountByExternalId=" + targetAccountByExternalId +
                '}';
    }

}
