package ru.yandex.intranet.d.services.operations.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.folders.FolderModel;

/**
 * Create account context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateAccountContext {

    private final FolderModel folder;
    private final Map<String, AccountModel> accountsById;
    private final AccountModel targetAccount;
    private final String abcServiceSlug;

    public CreateAccountContext(FolderModel folder,
                                Map<String, AccountModel> accountsById,
                                AccountModel targetAccount,
                                String abcServiceSlug) {
        this.folder = folder;
        this.accountsById = accountsById;
        this.targetAccount = targetAccount;
        this.abcServiceSlug = abcServiceSlug;
    }

    public FolderModel getFolder() {
        return folder;
    }

    public Map<String, AccountModel> getAccountsById() {
        return accountsById;
    }

    public Optional<AccountModel> getTargetAccount() {
        return Optional.ofNullable(targetAccount);
    }

    public String getAbcServiceSlug() {
        return abcServiceSlug;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountContext that = (CreateAccountContext) o;
        return Objects.equals(folder, that.folder) &&
                Objects.equals(accountsById, that.accountsById) &&
                Objects.equals(targetAccount, that.targetAccount) &&
                Objects.equals(abcServiceSlug, that.abcServiceSlug);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folder, accountsById, targetAccount, abcServiceSlug);
    }

    @Override
    public String toString() {
        return "CreateAccountContext{" +
                "folder=" + folder +
                ", accountsById=" + accountsById +
                ", targetAccount=" + targetAccount +
                ", abcServiceSlug='" + abcServiceSlug + '\'' +
                '}';
    }

}
