package ru.yandex.intranet.d.services.operations.model;

import java.util.List;
import java.util.Objects;

import ru.yandex.intranet.d.services.integration.providers.Response;
import ru.yandex.intranet.d.util.result.Result;

/**
 * Create account operation post-refresh context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateAccountOperationPostRefreshContext implements OperationPostRefreshContext {

    private final CreateAccountOperationRefreshContext refreshContext;
    private final Result<Response<List<ValidatedReceivedAccount>>> postRefreshResult;

    public CreateAccountOperationPostRefreshContext(
            CreateAccountOperationRefreshContext refreshContext,
            Result<Response<List<ValidatedReceivedAccount>>> postRefreshResult) {
        this.refreshContext = refreshContext;
        this.postRefreshResult = postRefreshResult;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return refreshContext.getCommonContext();
    }

    @Override
    public CreateAccountOperationPreRefreshContext getPreRefreshContext() {
        return refreshContext.getPreRefreshContext();
    }

    @Override
    public CreateAccountOperationRefreshContext getRefreshContext() {
        return refreshContext;
    }

    public Result<Response<List<ValidatedReceivedAccount>>> getPostRefreshResult() {
        return postRefreshResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountOperationPostRefreshContext that = (CreateAccountOperationPostRefreshContext) o;
        return Objects.equals(refreshContext, that.refreshContext) &&
                Objects.equals(postRefreshResult, that.postRefreshResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(refreshContext, postRefreshResult);
    }

    @Override
    public String toString() {
        return "CreateAccountOperationPostRefreshContext{" +
                "refreshContext=" + refreshContext +
                ", postRefreshResult=" + postRefreshResult +
                '}';
    }

}
