package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

/**
 * Create account operation pre-refresh context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateAccountOperationPreRefreshContext implements OperationPreRefreshContext {

    private final OperationCommonContext commonContext;
    private final CreateAccountContext createAccountContext;

    public CreateAccountOperationPreRefreshContext(OperationCommonContext commonContext,
                                                   CreateAccountContext createAccountContext) {
        this.commonContext = commonContext;
        this.createAccountContext = createAccountContext;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return commonContext;
    }

    public CreateAccountContext getCreateAccountContext() {
        return createAccountContext;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountOperationPreRefreshContext that = (CreateAccountOperationPreRefreshContext) o;
        return Objects.equals(commonContext, that.commonContext) &&
                Objects.equals(createAccountContext, that.createAccountContext);
    }

    @Override
    public int hashCode() {
        return Objects.hash(commonContext, createAccountContext);
    }

    @Override
    public String toString() {
        return "CreateAccountOperationPreRefreshContext{" +
                "commonContext=" + commonContext +
                ", createAccountContext=" + createAccountContext +
                '}';
    }

}
