package ru.yandex.intranet.d.services.operations.model;

import java.util.List;
import java.util.Objects;

import ru.yandex.intranet.d.services.integration.providers.Response;
import ru.yandex.intranet.d.util.result.Result;

/**
 * Create account operation refresh context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateAccountOperationRefreshContext implements OperationRefreshContext {

    private final CreateAccountOperationPreRefreshContext preRefreshContext;
    private final Result<Response<List<ReceivedAccount>>> refreshResult;

    public CreateAccountOperationRefreshContext(CreateAccountOperationPreRefreshContext preRefreshContext,
                                                Result<Response<List<ReceivedAccount>>> refreshResult) {
        this.preRefreshContext = preRefreshContext;
        this.refreshResult = refreshResult;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return preRefreshContext.getCommonContext();
    }

    @Override
    public CreateAccountOperationPreRefreshContext getPreRefreshContext() {
        return preRefreshContext;
    }

    public Result<Response<List<ReceivedAccount>>> getRefreshResult() {
        return refreshResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountOperationRefreshContext that = (CreateAccountOperationRefreshContext) o;
        return Objects.equals(preRefreshContext, that.preRefreshContext) &&
                Objects.equals(refreshResult, that.refreshResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preRefreshContext, refreshResult);
    }

    @Override
    public String toString() {
        return "CreateAccountOperationRefreshContext{" +
                "preRefreshContext=" + preRefreshContext +
                ", refreshResult=" + refreshResult +
                '}';
    }

}
