package ru.yandex.intranet.d.services.operations.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * Create account operation retry context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CreateAccountOperationRetryContext implements OperationRetryContext {

    private final CreateAccountOperationPostRefreshContext postRefreshContext;
    private final RefreshResult refreshResult;
    private final ValidatedReceivedAccount alreadyCreatedAccount;
    private final String receivedRefreshError;
    private final RetryResult retryResult;
    private final ReceivedAccount createdAccount;
    private final String receivedRetryError;
    private final PostRetryRefreshResult postRetryRefreshResult;
    private final List<ReceivedAccount> postRetryRefreshedAccounts;
    private final String receivedPostRetryRefreshError;
    private final String preGeneratedFolderOpLogId;

    @SuppressWarnings("ParameterNumber")
    public CreateAccountOperationRetryContext(CreateAccountOperationPostRefreshContext postRefreshContext,
                                              RefreshResult refreshResult,
                                              ValidatedReceivedAccount alreadyCreatedAccount,
                                              String receivedRefreshError,
                                              RetryResult retryResult,
                                              ReceivedAccount createdAccount,
                                              String receivedRetryError,
                                              PostRetryRefreshResult postRetryRefreshResult,
                                              List<ReceivedAccount> postRetryRefreshedAccounts,
                                              String receivedPostRetryRefreshError,
                                              String preGeneratedFolderOpLogId) {
        this.postRefreshContext = postRefreshContext;
        this.refreshResult = refreshResult;
        this.alreadyCreatedAccount = alreadyCreatedAccount;
        this.receivedRefreshError = receivedRefreshError;
        this.retryResult = retryResult;
        this.createdAccount = createdAccount;
        this.receivedRetryError = receivedRetryError;
        this.postRetryRefreshResult = postRetryRefreshResult;
        this.postRetryRefreshedAccounts = postRetryRefreshedAccounts;
        this.receivedPostRetryRefreshError = receivedPostRetryRefreshError;
        this.preGeneratedFolderOpLogId = preGeneratedFolderOpLogId;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return postRefreshContext.getCommonContext();
    }

    @Override
    public CreateAccountOperationPreRefreshContext getPreRefreshContext() {
        return postRefreshContext.getPreRefreshContext();
    }

    @Override
    public CreateAccountOperationRefreshContext getRefreshContext() {
        return postRefreshContext.getRefreshContext();
    }

    @Override
    public CreateAccountOperationPostRefreshContext getPostRefreshContext() {
        return postRefreshContext;
    }

    public RefreshResult getRefreshResult() {
        return refreshResult;
    }

    public Optional<ValidatedReceivedAccount> getAlreadyCreatedAccount() {
        return Optional.ofNullable(alreadyCreatedAccount);
    }

    public Optional<String> getReceivedRefreshError() {
        return Optional.ofNullable(receivedRefreshError);
    }

    @Override
    public Optional<RetryResult> getRetryResult() {
        return Optional.ofNullable(retryResult);
    }

    public Optional<ReceivedAccount> getCreatedAccount() {
        return Optional.ofNullable(createdAccount);
    }

    public Optional<String> getReceivedRetryError() {
        return Optional.ofNullable(receivedRetryError);
    }

    public Optional<PostRetryRefreshResult> getPostRetryRefreshResult() {
        return Optional.ofNullable(postRetryRefreshResult);
    }

    public Optional<List<ReceivedAccount>> getPostRetryRefreshedAccounts() {
        return Optional.ofNullable(postRetryRefreshedAccounts);
    }

    public Optional<String> getReceivedPostRetryRefreshError() {
        return Optional.ofNullable(receivedPostRetryRefreshError);
    }

    public String getPreGeneratedFolderOpLogId() {
        return preGeneratedFolderOpLogId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountOperationRetryContext that = (CreateAccountOperationRetryContext) o;
        return Objects.equals(postRefreshContext, that.postRefreshContext) &&
                refreshResult == that.refreshResult &&
                Objects.equals(alreadyCreatedAccount, that.alreadyCreatedAccount) &&
                Objects.equals(receivedRefreshError, that.receivedRefreshError) &&
                retryResult == that.retryResult &&
                Objects.equals(createdAccount, that.createdAccount) &&
                Objects.equals(receivedRetryError, that.receivedRetryError) &&
                postRetryRefreshResult == that.postRetryRefreshResult &&
                Objects.equals(postRetryRefreshedAccounts, that.postRetryRefreshedAccounts) &&
                Objects.equals(receivedPostRetryRefreshError, that.receivedPostRetryRefreshError) &&
                Objects.equals(preGeneratedFolderOpLogId, that.preGeneratedFolderOpLogId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(postRefreshContext, refreshResult, alreadyCreatedAccount, receivedRefreshError,
                retryResult, createdAccount, receivedRetryError, postRetryRefreshResult, postRetryRefreshedAccounts,
                receivedPostRetryRefreshError, preGeneratedFolderOpLogId);
    }

    @Override
    public String toString() {
        return "CreateAccountOperationRetryContext{" +
                "postRefreshContext=" + postRefreshContext +
                ", refreshResult=" + refreshResult +
                ", alreadyCreatedAccount=" + alreadyCreatedAccount +
                ", receivedRefreshError='" + receivedRefreshError + '\'' +
                ", retryResult=" + retryResult +
                ", createdAccount=" + createdAccount +
                ", receivedRetryError='" + receivedRetryError + '\'' +
                ", postRetryRefreshResult=" + postRetryRefreshResult +
                ", postRetryRefreshedAccounts=" + postRetryRefreshedAccounts +
                ", receivedPostRetryRefreshError='" + receivedPostRetryRefreshError + '\'' +
                ", preGeneratedFolderOpLogId='" + preGeneratedFolderOpLogId + '\'' +
                '}';
    }

}
