package ru.yandex.intranet.d.services.operations.model;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel;
import ru.yandex.intranet.d.model.folders.FolderModel;
import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Deliver and update provision context.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class DeliverUpdateProvisionContext {

    private final AccountModel account;
    private final FolderModel folder;
    private final Map<String, QuotaModel> folderQuotasByResourceId;
    private final Map<String, Map<String, AccountsQuotasModel>> provisionsByAccountIdResourceId;
    private final Map<String, AccountModel> accountsById;

    public DeliverUpdateProvisionContext(AccountModel account,
                                         FolderModel folder,
                                         Map<String, QuotaModel> folderQuotasByResourceId,
                                         Map<String, Map<String, AccountsQuotasModel>> provisionsByAccountIdResourceId,
                                         Map<String, AccountModel> accountsById) {
        this.account = account;
        this.folder = folder;
        this.folderQuotasByResourceId = folderQuotasByResourceId;
        this.provisionsByAccountIdResourceId = provisionsByAccountIdResourceId;
        this.accountsById = accountsById;
    }

    public AccountModel getAccount() {
        return account;
    }

    public FolderModel getFolder() {
        return folder;
    }

    public Map<String, QuotaModel> getFolderQuotasByResourceId() {
        return folderQuotasByResourceId;
    }

    public Map<String, Map<String, AccountsQuotasModel>> getProvisionsByAccountIdResourceId() {
        return provisionsByAccountIdResourceId;
    }

    public Map<String, AccountModel> getAccountsById() {
        return accountsById;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverUpdateProvisionContext that = (DeliverUpdateProvisionContext) o;
        return Objects.equals(account, that.account) && Objects.equals(folder, that.folder)
                && Objects.equals(folderQuotasByResourceId, that.folderQuotasByResourceId)
                && Objects.equals(provisionsByAccountIdResourceId, that.provisionsByAccountIdResourceId)
                && Objects.equals(accountsById, that.accountsById);
    }

    @Override
    public int hashCode() {
        return Objects.hash(account, folder, folderQuotasByResourceId, provisionsByAccountIdResourceId, accountsById);
    }

    @Override
    public String toString() {
        return "DeliverUpdateProvisionContext{" +
                "account=" + account +
                ", folder=" + folder +
                ", folderQuotasByResourceId=" + folderQuotasByResourceId +
                ", provisionsByAccountIdResourceId=" + provisionsByAccountIdResourceId +
                ", accountsById=" + accountsById +
                '}';
    }
}
