package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

import ru.yandex.intranet.d.services.integration.providers.Response;
import ru.yandex.intranet.d.util.result.Result;

/**
 * Deliver update provision operation post-refresh context.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class DeliverUpdateProvisionOperationPostRefreshContext implements OperationPostRefreshContext {
    private final DeliverUpdateProvisionOperationRefreshContext refreshContext;
    private final Result<Response<ValidatedReceivedAccount>> postRefreshResult;

    public DeliverUpdateProvisionOperationPostRefreshContext(
            DeliverUpdateProvisionOperationRefreshContext refreshContext,
            Result<Response<ValidatedReceivedAccount>> postRefreshResult) {
        this.refreshContext = refreshContext;
        this.postRefreshResult = postRefreshResult;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return refreshContext.getCommonContext();
    }

    @Override
    public DeliverUpdateProvisionOperationPreRefreshContext getPreRefreshContext() {
        return refreshContext.getPreRefreshContext();
    }

    @Override
    public DeliverUpdateProvisionOperationRefreshContext getRefreshContext() {
        return refreshContext;
    }

    public Result<Response<ValidatedReceivedAccount>> getPostRefreshResult() {
        return postRefreshResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverUpdateProvisionOperationPostRefreshContext that = (DeliverUpdateProvisionOperationPostRefreshContext) o;
        return Objects.equals(refreshContext, that.refreshContext) && Objects.equals(postRefreshResult,
                that.postRefreshResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(refreshContext, postRefreshResult);
    }

    @Override
    public String toString() {
        return "DeliverUpdateProvisionOperationPostRefreshContext{" +
                "refreshContext=" + refreshContext +
                ", postRefreshResult=" + postRefreshResult +
                '}';
    }
}
