package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

/**
 * Deliver and update provision operation pre-refresh context.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class DeliverUpdateProvisionOperationPreRefreshContext implements OperationPreRefreshContext {

    private final OperationCommonContext commonContext;
    private final DeliverUpdateProvisionContext deliverUpdateProvisionContext;

    public DeliverUpdateProvisionOperationPreRefreshContext(
            OperationCommonContext commonContext,
            DeliverUpdateProvisionContext deliverUpdateProvisionContext) {
        this.commonContext = commonContext;
        this.deliverUpdateProvisionContext = deliverUpdateProvisionContext;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return commonContext;
    }

    public DeliverUpdateProvisionContext getDeliverUpdateProvisionContext() {
        return deliverUpdateProvisionContext;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverUpdateProvisionOperationPreRefreshContext that = (DeliverUpdateProvisionOperationPreRefreshContext) o;
        return Objects.equals(commonContext, that.commonContext)
                && Objects.equals(deliverUpdateProvisionContext, that.deliverUpdateProvisionContext);
    }

    @Override
    public int hashCode() {
        return Objects.hash(commonContext, deliverUpdateProvisionContext);
    }

    @Override
    public String toString() {
        return "DeliverUpdateProvisionOperationPreRefreshContext{" +
                "commonContext=" + commonContext +
                ", deliverUpdateProvisionContext=" + deliverUpdateProvisionContext +
                '}';
    }
}
