package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

import ru.yandex.intranet.d.services.integration.providers.Response;
import ru.yandex.intranet.d.util.result.Result;

/**
 * Deliver update provision operation refresh context.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class DeliverUpdateProvisionOperationRefreshContext implements OperationRefreshContext {
    private final DeliverUpdateProvisionOperationPreRefreshContext preRefreshContext;
    private final Result<Response<ReceivedAccount>> refreshResult;

    public DeliverUpdateProvisionOperationRefreshContext(
            DeliverUpdateProvisionOperationPreRefreshContext preRefreshContext,
            Result<Response<ReceivedAccount>> refreshResult) {
        this.preRefreshContext = preRefreshContext;
        this.refreshResult = refreshResult;
    }

    @Override
    public DeliverUpdateProvisionOperationPreRefreshContext getPreRefreshContext() {
        return preRefreshContext;
    }

    @Override
    public OperationCommonContext getCommonContext() {
        return preRefreshContext.getCommonContext();
    }

    public Result<Response<ReceivedAccount>> getRefreshResult() {
        return refreshResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverUpdateProvisionOperationRefreshContext that = (DeliverUpdateProvisionOperationRefreshContext) o;
        return Objects.equals(preRefreshContext, that.preRefreshContext) && Objects.equals(refreshResult,
                that.refreshResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preRefreshContext, refreshResult);
    }

    @Override
    public String toString() {
        return "DeliverUpdateProvisionOperationRefreshContext{" +
                "preRefreshContext=" + preRefreshContext +
                ", refreshResult=" + refreshResult +
                '}';
    }
}
