package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;
import java.util.Set;

import ru.yandex.intranet.d.model.accounts.AccountSpaceModel;

/**
 * Expanded accounts space.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExpandedAccountSpace {

    private final AccountSpaceModel accountSpace;
    private final Set<ExpandedSegment> resourceSegments;

    public ExpandedAccountSpace(AccountSpaceModel accountSpace, Set<ExpandedSegment> resourceSegments) {
        this.accountSpace = accountSpace;
        this.resourceSegments = resourceSegments;
    }

    public AccountSpaceModel getAccountSpace() {
        return accountSpace;
    }

    public Set<ExpandedSegment> getResourceSegments() {
        return resourceSegments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedAccountSpace that = (ExpandedAccountSpace) o;
        return Objects.equals(accountSpace, that.accountSpace) &&
                Objects.equals(resourceSegments, that.resourceSegments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSpace, resourceSegments);
    }

    @Override
    public String toString() {
        return "ExpandedAccountSpace{" +
                "accountSpace=" + accountSpace +
                ", resourceSegments=" + resourceSegments +
                '}';
    }

}
