package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;
import java.util.Set;

import ru.yandex.intranet.d.model.resources.ResourceModel;
import ru.yandex.intranet.d.model.resources.types.ResourceTypeModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

/**
 * Expanded resource.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExpandedResource {

    private final ResourceModel resource;
    private final ResourceTypeModel resourceType;
    private final Set<ExpandedSegment> resourceSegments;
    private final UnitsEnsembleModel unitsEnsemble;

    public ExpandedResource(ResourceModel resource, ResourceTypeModel resourceType,
                            Set<ExpandedSegment> resourceSegments, UnitsEnsembleModel unitsEnsemble) {
        this.resource = resource;
        this.resourceType = resourceType;
        this.resourceSegments = resourceSegments;
        this.unitsEnsemble = unitsEnsemble;
    }

    public ResourceModel getResource() {
        return resource;
    }

    public ResourceTypeModel getResourceType() {
        return resourceType;
    }

    public Set<ExpandedSegment> getResourceSegments() {
        return resourceSegments;
    }

    public UnitsEnsembleModel getUnitsEnsemble() {
        return unitsEnsemble;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedResource that = (ExpandedResource) o;
        return Objects.equals(resource, that.resource) &&
                Objects.equals(resourceType, that.resourceType) &&
                Objects.equals(resourceSegments, that.resourceSegments) &&
                Objects.equals(unitsEnsemble, that.unitsEnsemble);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resource, resourceType, resourceSegments, unitsEnsemble);
    }

    @Override
    public String toString() {
        return "ExpandedResource{" +
                "resource=" + resource +
                ", resourceType=" + resourceType +
                ", resourceSegments=" + resourceSegments +
                ", unitsEnsemble=" + unitsEnsemble +
                '}';
    }

}
