package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel;

/**
 * Expanded segment.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExpandedSegment {

    private final ResourceSegmentationModel segmentation;
    private final ResourceSegmentModel segment;

    public ExpandedSegment(ResourceSegmentationModel segmentation, ResourceSegmentModel segment) {
        this.segmentation = segmentation;
        this.segment = segment;
    }

    public ResourceSegmentationModel getSegmentation() {
        return segmentation;
    }

    public ResourceSegmentModel getSegment() {
        return segment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpandedSegment that = (ExpandedSegment) o;
        return Objects.equals(segmentation, that.segmentation) &&
                Objects.equals(segment, that.segment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentation, segment);
    }

    @Override
    public String toString() {
        return "ExpandedSegment{" +
                "segmentation=" + segmentation +
                ", segment=" + segment +
                '}';
    }

}
