package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;
import java.util.Set;

/**
 * External accounts space key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalAccountsSpaceKey {

    private final Set<ExternalSegmentKey> segments;

    public ExternalAccountsSpaceKey(Set<ExternalSegmentKey> segments) {
        this.segments = segments;
    }

    public Set<ExternalSegmentKey> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalAccountsSpaceKey that = (ExternalAccountsSpaceKey) o;
        return Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segments);
    }

    @Override
    public String toString() {
        return "ExternalAccountsSpaceKey{" +
                "segments=" + segments +
                '}';
    }

}
