package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;
import java.util.Set;

/**
 * External resource key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalResourceKey {

    private final String resourceTypeKey;
    private final Set<ExternalSegmentKey> segments;

    public ExternalResourceKey(String resourceTypeKey, Set<ExternalSegmentKey> segments) {
        this.resourceTypeKey = resourceTypeKey;
        this.segments = segments;
    }

    public String getResourceTypeKey() {
        return resourceTypeKey;
    }

    public Set<ExternalSegmentKey> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalResourceKey that = (ExternalResourceKey) o;
        return Objects.equals(resourceTypeKey, that.resourceTypeKey) &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeKey, segments);
    }

    @Override
    public String toString() {
        return "ExternalResourceKey{" +
                "resourceTypeKey='" + resourceTypeKey + '\'' +
                ", segments=" + segments +
                '}';
    }

}
