package ru.yandex.intranet.d.services.operations.model;

import java.util.Objects;

/**
 * External segment key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ExternalSegmentKey {

    private final String segmentationKey;
    private final String segmentKey;

    public ExternalSegmentKey(String segmentationKey, String segmentKey) {
        this.segmentationKey = segmentationKey;
        this.segmentKey = segmentKey;
    }

    public String getSegmentationKey() {
        return segmentationKey;
    }

    public String getSegmentKey() {
        return segmentKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExternalSegmentKey that = (ExternalSegmentKey) o;
        return Objects.equals(segmentationKey, that.segmentationKey) &&
                Objects.equals(segmentKey, that.segmentKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationKey, segmentKey);
    }

    @Override
    public String toString() {
        return "ExternalSegmentKey{" +
                "segmentationKey='" + segmentationKey + '\'' +
                ", segmentKey='" + segmentKey + '\'' +
                '}';
    }

}
