package ru.yandex.intranet.d.services.operations.model

import ru.yandex.intranet.d.services.integration.providers.Response
import ru.yandex.intranet.d.util.result.Result

/**
 * MoveProvisionOperationPostRefreshContext.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 21-12-2021
 */
data class MoveProvisionOperationPostRefreshContext(
    val context: MoveProvisionOperationRefreshContext,
    val validatedAccountFrom: Result<Response<ValidatedReceivedAccount>>,
    val validatedAccountTo: Result<Response<ValidatedReceivedAccount>>,
): OperationPostRefreshContext {
    override fun getCommonContext(): OperationCommonContext {
        return context.commonContext
    }

    override fun getPreRefreshContext(): MoveProvisionOperationPreRefreshContext {
        return context.preRefreshContext
    }

    override fun getRefreshContext(): MoveProvisionOperationRefreshContext {
        return context
    }
}
