package ru.yandex.intranet.d.services.operations.model

import ru.yandex.intranet.d.services.integration.providers.Response
import ru.yandex.intranet.d.util.result.Result

/**
 * MoveProvisionOperationRefreshContext.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 20-12-2021
 */
class MoveProvisionOperationRefreshContext(
    private val preRefreshContext: MoveProvisionOperationPreRefreshContext,
    val receivedAccountFrom: Result<Response<ReceivedAccount>>,
    val receivedAccountTo: Result<Response<ReceivedAccount>>,
) : OperationRefreshContext{
    override fun getCommonContext(): OperationCommonContext {
        return preRefreshContext.commonContext
    }

    override fun getPreRefreshContext(): MoveProvisionOperationPreRefreshContext {
        return preRefreshContext
    }
}
