package ru.yandex.intranet.d.services.operations.model

import ru.yandex.intranet.d.util.result.LocalizedErrors
import java.util.*

data class MoveProvisionOperationRetryContext(
    private val commonContext: OperationCommonContext,
    private val preRefreshContext: MoveProvisionOperationPreRefreshContext,
    private val refreshContext: MoveProvisionOperationRefreshContext,
    private val postRefreshContext: MoveProvisionOperationPostRefreshContext,
    private val retryResult: RetryResult? = null,
    val refreshResult: RefreshResult,
    val receivedMoveProvision: ReceivedMoveProvision? = null,
    val postRetryRefreshResult: PostRetryRefreshResult? = null,
    val refreshedSourceAccount: ValidatedReceivedAccount? = null,
    val refreshedDestinationAccount: ValidatedReceivedAccount? = null,
    val postRetrySourceAccount: ReceivedAccount? = null,
    val postRetryDestinationAccount: ReceivedAccount? = null,
    val refreshErrors: LocalizedErrors? = null,
    val retryErrors: LocalizedErrors? = null,
    val postRetryErrors: LocalizedErrors? = null,
) : OperationRetryContext {
    override fun getCommonContext(): OperationCommonContext {
        return commonContext
    }

    override fun getPreRefreshContext(): MoveProvisionOperationPreRefreshContext {
        return preRefreshContext
    }

    override fun getRefreshContext(): MoveProvisionOperationRefreshContext {
        return refreshContext
    }

    override fun getPostRefreshContext(): MoveProvisionOperationPostRefreshContext {
        return postRefreshContext
    }

    override fun getRetryResult(): Optional<RetryResult> {
        return Optional.ofNullable(retryResult)
    }
}
