package ru.yandex.intranet.d.services.operations.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.model.accounts.AccountSpaceModel;
import ru.yandex.intranet.d.model.providers.ProviderModel;
import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Operation retry common context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class OperationCommonContext {

    private final ProviderModel provider;
    private final AccountSpaceModel accountsSpace;
    private final UserModel author;
    private final Map<ExternalResourceKey, ExpandedResource> externalResourceIndex;
    private final Map<String, ExpandedResource> resourceIndex;
    private final Map<ExternalAccountsSpaceKey, ExpandedAccountSpace> externalAccountsSpaceIndex;
    private final Map<String, ExpandedAccountSpace> accountsSpaceIndex;

    public OperationCommonContext(ProviderModel provider,
                                  AccountSpaceModel accountsSpace,
                                  UserModel author,
                                  Map<ExternalResourceKey, ExpandedResource> externalResourceIndex,
                                  Map<String, ExpandedResource> resourceIndex,
                                  Map<ExternalAccountsSpaceKey, ExpandedAccountSpace> externalAccountsSpaceIndex,
                                  Map<String, ExpandedAccountSpace> accountsSpaceIndex) {
        this.provider = provider;
        this.accountsSpace = accountsSpace;
        this.author = author;
        this.externalResourceIndex = externalResourceIndex;
        this.resourceIndex = resourceIndex;
        this.externalAccountsSpaceIndex = externalAccountsSpaceIndex;
        this.accountsSpaceIndex = accountsSpaceIndex;
    }

    public ProviderModel getProvider() {
        return provider;
    }

    public Optional<AccountSpaceModel> getAccountsSpace() {
        return Optional.ofNullable(accountsSpace);
    }

    public UserModel getAuthor() {
        return author;
    }

    public Map<ExternalResourceKey, ExpandedResource> getExternalResourceIndex() {
        return externalResourceIndex;
    }

    public Map<String, ExpandedResource> getResourceIndex() {
        return resourceIndex;
    }

    public Map<ExternalAccountsSpaceKey, ExpandedAccountSpace> getExternalAccountsSpaceIndex() {
        return externalAccountsSpaceIndex;
    }

    public Map<String, ExpandedAccountSpace> getAccountsSpaceIndex() {
        return accountsSpaceIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationCommonContext that = (OperationCommonContext) o;
        return Objects.equals(provider, that.provider)
                && Objects.equals(accountsSpace, that.accountsSpace)
                && Objects.equals(author, that.author)
                && Objects.equals(externalResourceIndex, that.externalResourceIndex)
                && Objects.equals(resourceIndex, that.resourceIndex)
                && Objects.equals(externalAccountsSpaceIndex, that.externalAccountsSpaceIndex)
                && Objects.equals(accountsSpaceIndex, that.accountsSpaceIndex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provider, accountsSpace, author, externalResourceIndex, resourceIndex,
                externalAccountsSpaceIndex, accountsSpaceIndex);
    }

    @Override
    public String toString() {
        return "OperationCommonContext{" +
                "provider=" + provider +
                ", accountsSpace=" + accountsSpace +
                ", author=" + author +
                ", externalResourceIndex=" + externalResourceIndex +
                ", resourceIndex=" + resourceIndex +
                ", externalAccountsSpaceIndex=" + externalAccountsSpaceIndex +
                ", accountsSpaceIndex=" + accountsSpaceIndex +
                '}';
    }

}
