package ru.yandex.intranet.d.services.operations.model

import ru.yandex.intranet.d.services.integration.providers.Response
import ru.yandex.intranet.d.util.result.Result

/**
 * Provide reserve operation refresh context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
class ProvideReserveOperationRefreshContext(
    private val preRefreshContext: ProvideReserveOperationPreRefreshContext,
    val refreshedAccount: Result<Response<ReceivedAccount>>
): OperationRefreshContext {
    override fun getCommonContext(): OperationCommonContext {
        return preRefreshContext.commonContext
    }

    override fun getPreRefreshContext(): ProvideReserveOperationPreRefreshContext {
        return preRefreshContext
    }
}
