package ru.yandex.intranet.d.services.operations.model

import ru.yandex.intranet.d.util.result.LocalizedErrors
import java.util.*

/**
 * Provide reserve operation retry context.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
class ProvideReserveOperationRetryContext(
    private val postRefreshContext: ProvideReserveOperationPostRefreshContext,
    private val retryResult: RetryResult? = null,
    val updatedProvision: ReceivedUpdatedProvision? = null,
    val retryErrors: LocalizedErrors? = null,
    val postRetryRefreshAccount: ReceivedAccount? = null,
    val postRetryRefreshResult: PostRetryRefreshResult? = null,
    val postRetryRefreshErrors: LocalizedErrors? = null
): OperationRetryContext {

    override fun getCommonContext(): OperationCommonContext {
        return postRefreshContext.commonContext
    }

    override fun getPreRefreshContext(): ProvideReserveOperationPreRefreshContext {
        return postRefreshContext.preRefreshContext
    }

    override fun getRefreshContext(): ProvideReserveOperationRefreshContext {
        return postRefreshContext.refreshContext
    }

    override fun getPostRefreshContext(): ProvideReserveOperationPostRefreshContext {
        return postRefreshContext
    }

    override fun getRetryResult(): Optional<RetryResult> {
        return Optional.ofNullable(retryResult)
    }

}
