package ru.yandex.intranet.d.services.operations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * Received accounts space key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReceivedAccountsSpaceKey {

    private final List<ReceivedSegmentKey> segmentation;

    public ReceivedAccountsSpaceKey(List<ReceivedSegmentKey> segmentation) {
        this.segmentation = segmentation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<ReceivedSegmentKey> getSegmentation() {
        return segmentation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReceivedAccountsSpaceKey that = (ReceivedAccountsSpaceKey) o;
        return Objects.equals(segmentation, that.segmentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentation);
    }

    @Override
    public String toString() {
        return "ReceivedAccountsSpaceKey{" +
                "segmentation=" + segmentation +
                '}';
    }

    public static final class Builder {

        private final List<ReceivedSegmentKey> segmentation = new ArrayList<>();

        private Builder() {
        }

        public Builder addSegment(ReceivedSegmentKey segment) {
            segmentation.add(segment);
            return this;
        }

        public Builder addSegments(Collection<? extends ReceivedSegmentKey> segments) {
            segmentation.addAll(segments);
            return this;
        }

        public ReceivedAccountsSpaceKey build() {
            return new ReceivedAccountsSpaceKey(segmentation);
        }

    }

}
