package ru.yandex.intranet.d.services.operations.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

/**
 * Received last update.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReceivedLastUpdate {

    private final Instant timestamp;
    private final ReceivedUserId author;
    private final String operationId;

    public ReceivedLastUpdate(Instant timestamp, ReceivedUserId author, String operationId) {
        this.timestamp = timestamp;
        this.author = author;
        this.operationId = operationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable(timestamp);
    }

    public Optional<ReceivedUserId> getAuthor() {
        return Optional.ofNullable(author);
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(operationId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReceivedLastUpdate that = (ReceivedLastUpdate) o;
        return Objects.equals(timestamp, that.timestamp) &&
                Objects.equals(author, that.author) &&
                Objects.equals(operationId, that.operationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(timestamp, author, operationId);
    }

    @Override
    public String toString() {
        return "ReceivedLastUpdate{" +
                "timestamp=" + timestamp +
                ", author=" + author +
                ", operationId='" + operationId + '\'' +
                '}';
    }

    public static final class Builder {

        private Instant timestamp;
        private ReceivedUserId author;
        private String operationId;

        private Builder() {
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder author(ReceivedUserId author) {
            this.author = author;
            return this;
        }

        public Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public ReceivedLastUpdate build() {
            return new ReceivedLastUpdate(timestamp, author, operationId);
        }

    }

}
