package ru.yandex.intranet.d.services.operations.model

import java.util.*

data class ReceivedMoveProvision(
    val sourceProvisions: List<ReceivedProvision>,
    val destinationProvisions: List<ReceivedProvision>,
    private val accountSpaceKey: ReceivedAccountsSpaceKey?,
    private val sourceAccountVersion: Long?,
    private val destinationAccountVersion: Long?,
) {
    fun getAccountSpaceKey() = Optional.ofNullable(accountSpaceKey)

    fun getSourceAccountVersion() = Optional.ofNullable(sourceAccountVersion)

    fun getDestinationAccountVersion() = Optional.ofNullable(destinationAccountVersion)

    companion object {
        @JvmStatic
        fun builder() = Builder()
    }

    data class Builder(
        private val sourceProvisions: MutableList<ReceivedProvision> = mutableListOf(),
        private val destinationProvisions: MutableList<ReceivedProvision> = mutableListOf(),
        private var accountSpaceKey: ReceivedAccountsSpaceKey? = null,
        private var sourceAccountVersion: Long? = null,
        private var destinationAccountVersion: Long? = null,
    ) {
        fun addSourceProvision(receivedProvision: ReceivedProvision) = apply {
            sourceProvisions += receivedProvision
        }

        fun addDestinationProvision(receivedProvision: ReceivedProvision) = apply {
            destinationProvisions += receivedProvision
        }

        fun accountSpaceKey(accountSpaceKey: ReceivedAccountsSpaceKey) = apply {
            this.accountSpaceKey = accountSpaceKey
        }

        fun sourceAccountVersion(sourceAccountVersion: Long) = apply {
            this.sourceAccountVersion = sourceAccountVersion
        }

        fun destinationAccountVersion(destinationAccountVersion: Long) = apply {
            this.destinationAccountVersion = destinationAccountVersion
        }

        fun build() = ReceivedMoveProvision(
            sourceProvisions, destinationProvisions, accountSpaceKey, sourceAccountVersion, destinationAccountVersion
        )
    }
}
