package ru.yandex.intranet.d.services.operations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * Received resource key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ReceivedResourceKey {

    private final String resourceTypeKey;
    private final List<ReceivedSegmentKey> segmentation;

    public ReceivedResourceKey(String resourceTypeKey, List<ReceivedSegmentKey> segmentation) {
        this.resourceTypeKey = resourceTypeKey;
        this.segmentation = segmentation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResourceTypeKey() {
        return resourceTypeKey;
    }

    public List<ReceivedSegmentKey> getSegmentation() {
        return segmentation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReceivedResourceKey that = (ReceivedResourceKey) o;
        return Objects.equals(resourceTypeKey, that.resourceTypeKey) &&
                Objects.equals(segmentation, that.segmentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeKey, segmentation);
    }

    @Override
    public String toString() {
        return "ReceivedResourceKey{" +
                "resourceTypeKey='" + resourceTypeKey + '\'' +
                ", segmentation=" + segmentation +
                '}';
    }

    public static final class Builder {

        private final List<ReceivedSegmentKey> segmentation = new ArrayList<>();

        private String resourceTypeKey;

        private Builder() {
        }

        public Builder resourceTypeKey(String resourceTypeKey) {
            this.resourceTypeKey = resourceTypeKey;
            return this;
        }

        public Builder addSegment(ReceivedSegmentKey segment) {
            segmentation.add(segment);
            return this;
        }

        public Builder addSegments(Collection<? extends ReceivedSegmentKey> segments) {
            segmentation.addAll(segments);
            return this;
        }

        public ReceivedResourceKey build() {
            Preconditions.checkNotNull(resourceTypeKey, "ResourceTypeKey is required");
            return new ReceivedResourceKey(resourceTypeKey, segmentation);
        }

    }

}
